
/*******************************************************************************/
/*  
	This script produces Table A2
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/

// ___________________________________________________
// ASEC 2019
use "../Data/CPS/clean_cps19.dta", clear
gen lhours = log(hours_ann)

// __________________________________________________
// LABEL VARS
label var college "College degree"
label var male "Male"
label var employer_health "Has employer healthcare"
label var own_home "Owns home"
label var born_50states "Born in US"
label var married "Married"
label var big_firm "Big firm (500+ emp.)"
label var is_citizen "US citizen"
label var white "White"
label var fulltime "Full-time employed"
label var no_unemp "No unemployment last year"
label var old "Age 50+"

label var age "Age"
label var wage "Hourly wage"
label var lhours "Log annual hours"
label var years_school "Years of education"

// __________________________________________________
// SUMMARY STATS
eststo clear
eststo: qui estpost summarize ///
    age wage lhours years_school college male employer_health own_home born_50states married big_firm 	is_citizen white fulltime no_unemp old, detail // format

esttab using "../Tables/tableA2.tex", cells("mean(fmt(2)) p50(fmt(2)) sd(fmt(2))") label nodepvar nomtitles ///
	varwidth(25) nonumbers booktabs title("CPS - 2019 March Supplement") ///
	replace


// end
